#include <stdio.h>
#include <stdlib.h>


/* A program for converting an Intel hex file to a C include file
   which makes a C array of chars corresponding to the data. */
/* Currently supports only record types 00 and 01. */

char checksum(char *line);
void getln(char *line, FILE *ifp);
int decode(char *line, int *paddress, int *prectype, int *pdatacount, char *rddata);

int main(int argc, char **argv) {
    
    char line[521];
    char c;
    int datacount;
    int address;
    int rectype;
    char rddata[255];
    char *pdata;
    char *pc;
    int maxaddress;
    int pass;
    int i;
    FILE *ifp;
    FILE *ofp;
    
    
    if (argc != 4) {
        fprintf(stderr, "\nusage: hex2inc <hexfile> <outfile> <arrname>\n");
        return 1;
    }
    ifp = fopen(argv[1], "rb");
    if (!ifp || ferror(ifp)) {
        fprintf(stderr, "\nERROR opening '%s' as \"rb\"\n", argv[1]);
        if (ifp) {
            fclose(ifp);
        }
        return 2;
    }
    maxaddress = 0;
    /* first pass of hex file: determine max address */
    /* second pass: put data in array */
    for (pass = 1; pass < 3; ++pass) {
        
        /* read through file */
        while (1) {
            getln(line, ifp);
            if (ferror(ifp)) {
                fprintf(stderr, "\nERROR reading '%s'\n", argv[1]);
                fclose(ifp);
                return 4;
            }
            if (!line[0]) {
                fprintf(stderr, "\nERROR unexpected EOF in '%s'\n", argv[1]);
                fclose(ifp);
                return 5;
            }
            if (checksum(line) != 0) {
                fprintf(stderr, "\nERROR line checksum in '%s'\n", argv[1]);
                fclose(ifp);
                return 7;
            }
            if (decode(line, &address, &rectype, &datacount, rddata) != 0) {
                fprintf(stderr, "\nERROR decoding line in '%s'\n", argv[1]);
                fclose(ifp);
                return 8;
            }
            if (rectype == 1) {
                break; /* end of file */
            }
            /* it's a data record */
            if (pass == 1) {
                maxaddress = address + datacount - 1;
            } else {
                /* copy data into array */
                pc = pdata + address;
                for (i = 0; i < datacount; ++i) {
                    *pc = rddata[i];
                    ++pc;
                }
            }
        }
        /* we get here when the end of file record is reached */
        /* make sure nothing else is in the file */
        getln(line, ifp);
        if (ferror(ifp)) {
            fprintf(stderr, "\nERROR reading '%s'\n", argv[1]);
            fclose(ifp);
            return 10;
        }
        if (line[0] != 0) {
            fprintf(stderr, "\nERROR extra line(s) in '%s'\n", argv[1]);
            fclose(ifp);
            return 11;
        }
        
        if (pass == 1) {
            
            /* get memory to put the data in */
            pdata = calloc(maxaddress+1, 1);
            if (!pdata) {
                fprintf(stderr, "\nERROR allocating memory\n");
                fclose(ifp);
                return 12;
            }
            /* prepare for next pass */
            rewind(ifp);
        }
    }
    fclose(ifp);
    
    /* now we write the include file */
    ofp = fopen(argv[2], "w");
    if (!ofp || ferror(ofp)) {
        fprintf(stderr, "\nERROR creating '%s' as \"w\"\n", argv[2]);
        if (ofp) {
            fclose(ofp);
        }
        return 3;
    }
    fprintf(ofp, "char %s[] = {\n  ", argv[3]);
    for (i = 0; maxaddress - i >= 8 && !ferror(ofp); i += 8) {
        fprintf(ofp,
            "0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,\n  ",
            (int)pdata[i+0] & 0x0ff, (int)pdata[i+1] & 0x0ff,
            (int)pdata[i+2] & 0x0ff, (int)pdata[i+3] & 0x0ff,
            (int)pdata[i+4] & 0x0ff, (int)pdata[i+5] & 0x0ff,
            (int)pdata[i+6] & 0x0ff, (int)pdata[i+7] & 0x0ff);
    }
    for ( ; i < maxaddress && !ferror(ofp); ++i) {
        fprintf(ofp, "0x%02x, ", (int)pdata[i] & 0x0ff);
    }
    if (i == maxaddress && !ferror(ofp)) {
        fprintf(ofp, "0x%02x", (int)pdata[i] & 0x0ff);
    }
    if (!ferror(ofp)) {
        fprintf(ofp, "\n  };\n");
    }
    if (ferror(ofp)) {
        fclose(ofp);
        fprintf(stderr, "\nERROR writing '%s'\n", argv[2]);
        return 13;
    }
    fclose(ofp);
    
    free(pdata);
    return 0;
}

/* computes checksum of a line from an Intel hex record file */
/* checksum is correct iff returned value is zero */
char checksum(char *line) {
    char c;
    int ci;
    char hex[3];
    ++line; /* skip the ':' */
    c = 0;
    hex[2] = 0; /* null-terminate string */
    while (*line) {
        hex[0] = *line;
        ++line;
        if (!*line) {
            return 1; /* should have been an even # chars */
        }
        hex[1] = *line;
        ++line;
        if (sscanf(hex, "%2x", &ci) != 1) {
            return 1;
        }
        c += (char)(ci & 0x0ff);
    }
    return c;
}

/* gets line from text file, up to max 520chars + null-term */
/* an empty line returned with error indicator not set means end of file */
/* caller should check file error indicator on return */
void getln(char *line, FILE *ifp) {
    int i;
    char c;
    if (feof(ifp) || ferror(ifp)) {
        line[0] = 0;
        return;
    }
    c = fgetc(ifp);
    /* skip leading line feeds & carriage returns */
    while ((c == 0x0d || c == 0x0a) && !feof(ifp) && !ferror(ifp)) {
        c = fgetc(ifp);
    }
    /* get line */
    for (i = 0 ; i < 520 && !feof(ifp) && !ferror(ifp); ++i) {
        if (c == 0x0d || c == 0x0a) {
            break;
        }
        line[i] = c;
        c = fgetc(ifp);
    }
    line[i] = 0;
    return;
}

/* helper for decode */
int decodeint(char **pline, int *pval, int numdigits) {
    int j;
    char hex[5];
    char fmts[] = "%?x";
    
    if (numdigits < 1) {
        return 0;
    }
    if (numdigits > 4) {
        return 0;
    }
    for (j = 0; j < numdigits; ++j) {
        if (**pline == 0) {
            return 0;
        }
        hex[j] = **pline;
        ++*pline;
    }
    hex[j] = 0;
    fmts[1] = (char)(numdigits + '0');
    if (sscanf(hex, fmts, pval) != 1) {
        return 0;
    }
    return 1; /* success */
}

/* decodes a line from an Intel hex record file */
/* returns nonzero if any error */
int decode(char *line, int *paddress, int *prectype, int *pdatacount, char *rddata) {
    
    char hex[5];
    int i;
    int temp;
    
    /* start code */
    if (*line != ':')
        return 1;
    ++line;
    
    /* byte count */
    if (!decodeint(&line, pdatacount, 2)) {
        return 1;
    }
        
    /* address */
    if (!decodeint(&line, paddress, 4)) {
        return 1;
    }
        
    /* record type */
    if (!decodeint(&line, prectype, 2)) {
        return 1;
    }
    /* 00 = data record, 01 = EOF record, others not supported */
    if (*prectype == 1) {
        /* data count should be 0 for EOF record */
        if (*pdatacount != 0) {
            return 1;
        }
    } else if (*prectype != 0) {
        return 1;
    }
    
    /* expect *pdatacount bytes of data */
    for (i = 0; i < *pdatacount; ++i) {
        if (!decodeint(&line, &temp, 2)) {
            return 1;
        }
        rddata[i] = (char)(temp & 0x0ff);
    }
    
    /* expect 2 more bytes for checksum */
    if (line[0] == 0 || line[1] == 0 || line[2] != 0) {
        return 1;
    }
    
    return 0;
}

